<?php

namespace App\Http\Controllers;

use App\Models\Settings;
use App\Theme;
use Illuminate\Http\Request;

class ThemeController extends Controller
{
    private function getSettings()
    {
        $settings = Settings::first();

        if (!$settings || !$settings->theme) {
            // Default to digimarket if no theme is set
            $theme = Theme::DIGIMARKET;
            $settings = new Settings();
            $settings->theme = $theme;
            $settings->website_name = 'DigiMarket';
            $settings->website_content_name = 'Digital Products';
            $settings->primary_color = null; // Ensure primary_color is set
        }

        return $settings;
    }

    public function index()
    {
        $settings = $this->getSettings();
        $theme = $settings->theme;
        $services = \App\Models\Service::active()->ordered()->get();

        return view("themes.{$theme->value}.home", compact('settings', 'theme', 'services'));
    }

    public function about()
    {
        $settings = $this->getSettings();
        $theme = $settings->theme;
        $services = \App\Models\Service::active()->ordered()->get();

        return view("themes.{$theme->value}.about", compact('settings', 'theme', 'services'));
    }

    public function contact()
    {
        $settings = $this->getSettings();
        $theme = $settings->theme;
        $services = \App\Models\Service::active()->ordered()->get();

        return view("themes.{$theme->value}.contact", compact('settings', 'theme', 'services'));
    }

    public function pricing()
    {
        $settings = $this->getSettings();
        $theme = $settings->theme;
        $services = \App\Models\Service::active()->ordered()->get();

        return view("themes.{$theme->value}.pricing", compact('settings', 'theme', 'services'));
    }

    public function privacyPolicy()
    {
        $settings = $this->getSettings();
        $theme = $settings->theme;
        $services = \App\Models\Service::active()->ordered()->get();

        return view("themes.{$theme->value}.privacy-policy", compact('settings', 'theme', 'services'));
    }

    public function termsConditions()
    {
        $settings = $this->getSettings();
        $theme = $settings->theme;
        $services = \App\Models\Service::active()->ordered()->get();

        return view("themes.{$theme->value}.terms-conditions", compact('settings', 'theme', 'services'));
    }

    public function refundPolicy()
    {
        $settings = $this->getSettings();
        $theme = $settings->theme;
        $services = \App\Models\Service::active()->ordered()->get();

        return view("themes.{$theme->value}.refund-policy", compact('settings', 'theme', 'services'));
    }


}
