import type { Config as TailwindConfig } from "tailwindcss/types/config";
import Formatter from "./formatter";
import { type EndOfLine, type RuntimeConfig, type SortHtmlAttributes, type WrapAttributes } from "./runtimeConfig";
export type CLIOption = {
    write?: boolean;
    diff?: boolean;
    checkFormatted?: boolean;
    progress?: boolean;
    ignoreFilePath?: string;
    runtimeConfigPath?: string;
};
export type FormatterOption = {
    indentSize?: number;
    wrapLineLength?: number;
    wrapAttributes?: WrapAttributes;
    wrapAttributesMinAttrs?: number;
    indentInnerHtml?: boolean;
    endWithNewline?: boolean;
    endOfLine?: EndOfLine;
    useTabs?: boolean;
    sortTailwindcssClasses?: true;
    tailwindcssConfigPath?: string;
    tailwindcssConfig?: TailwindConfig;
    sortHtmlAttributes?: SortHtmlAttributes;
    customHtmlAttributesOrder?: string[] | string;
    noMultipleEmptyLines?: boolean;
    noPhpSyntaxCheck?: boolean;
    noSingleQuote?: boolean;
    noTrailingCommaPhp?: boolean;
    extraLiners?: string[];
    componentPrefix?: string[];
};
export type BladeFormatterOption = CLIOption & FormatterOption;
declare class BladeFormatter {
    diffs: any;
    errors: any;
    formattedFiles: any;
    ignoreFile: string;
    options: FormatterOption & CLIOption;
    outputs: any;
    currentTargetPath: string;
    paths: any;
    targetFiles: any;
    fulFillFiles: any;
    static targetFiles: any;
    runtimeConfigPath: string | null;
    runtimeConfigCache: RuntimeConfig;
    constructor(options?: BladeFormatterOption, paths?: any);
    format(content: any, opts?: BladeFormatterOption): Promise<any>;
    formatFromCLI(): Promise<void>;
    fileExists(filepath: string): any;
    readIgnoreFile(filePath: string): Promise<void>;
    findTailwindConfig(filePath: string): Promise<void>;
    readRuntimeConfig(filePath: string): Promise<RuntimeConfig | undefined>;
    handleConfigError(configFile: string, error: any): void;
    processPaths(): Promise<void>;
    processPath(path: any): Promise<void>;
    static globFiles(path: any): Promise<string[]>;
    filterFiles(paths: any): Promise<any>;
    static fulFillFiles(paths: any): Promise<any>;
    formatFiles(paths: any): Promise<void>;
    formatFile(path: any): Promise<void>;
    checkFormatted(path: any, formatted: any): Promise<any>;
    printFormattedOutput(path: any, formatted: any): void;
    writeToFile(path: any, content: any): void;
    handleError(path: any, error: any): void;
    printPreamble(): void;
    printResults(): Promise<void>;
    printDescription(): void;
    printFormattedFiles(): void;
    printDifferences(): void;
    printErrors(): void;
}
export { BladeFormatter, Formatter };
