import detectIndent from "detect-indent";
import { Processor } from "./processor";
export declare class BladeDirectiveInScriptsProcessor extends Processor {
    private bladeDirectives;
    private directivesInScript;
    private rawBlocks;
    private customDirectives;
    private stringLiteralInPhp;
    preProcess(content: string): Promise<any>;
    postProcess(content: string): Promise<any>;
    private preserveBladeDirectiveInScripts;
    /**
     *
     * @param content string between <script>~</script>
     * @returns string
     */
    preserveCustomDirectiveInScript(content: string): string;
    private restoreBladeDirectiveInScripts;
    storeBladeDirective(value: any): any;
    storeBladeDirectiveInScript(value: string): any;
    getBladeDirectiveInScriptPlaceholder(replace: any): any;
    getBladeDirectivePlaceholder(replace: any): any;
    getInlinePhpPlaceholder(replace: any): any;
    formatExpressionInsideBladeDirective(matchedExpression: string, indent: detectIndent.Indent, wrapLength?: number | undefined): Promise<any>;
    storeRawBlock(value: any): any;
    getRawPlaceholder(replace: any): any;
    storeInlineCustomDirective(value: string): any;
    getInlineCustomDirectivePlaceholder(replace: string): any;
    preserveStringLiteralInPhp(content: any): any;
    storeStringLiteralInPhp(value: any): any;
    getStringLiteralInPhpPlaceholder(replace: any): any;
    restoreStringLiteralInPhp(content: any): any;
    formatPreservedBladeDirectives(directives: any): Promise<any[]>;
}
