import detectIndent from "detect-indent";
import type { Formatter } from "./main";
import type { EndOfLine } from "./runtimeConfig";
export declare const optional: (obj: any) => any;
export declare function readFile(path: any): Promise<unknown>;
export declare function splitByLines(content: any): any;
export type FormatPhpOption = {
    noPhpSyntaxCheck?: boolean;
    printWidth?: number;
    trailingCommaPHP?: boolean;
    phpVersion?: string;
    noSingleQuote?: boolean;
};
export declare const printWidthForInline = 1000;
export declare function formatStringAsPhp(content: any, params?: FormatPhpOption): Promise<string>;
export declare function formatRawStringAsPhp(content: string, params?: FormatPhpOption): Promise<string>;
export declare function getArgumentsCount(expression: string): Promise<any>;
export declare function normalizeIndentLevel(length: any): any;
export declare function printDiffs(diffs: any): Promise<any>;
export declare function generateDiff(path: any, originalLines: any, formattedLines: any): any;
export declare function prettifyPhpContentWithUnescapedTags(content: string, options: FormatPhpOption): Promise<string>;
export declare function prettifyPhpContentWithEscapedTags(content: string, options: FormatPhpOption): Promise<any>;
export declare function removeSemicolon(content: any): Promise<any>;
export declare function formatAsPhp(content: string, options: FormatPhpOption): Promise<string>;
export declare function preserveOriginalPhpTagInHtml(content: any): Promise<any>;
export declare function revertOriginalPhpTagInHtml(content: any): Promise<any>;
export declare function indent(content: any, level: any, options: any): any;
export declare function unindent(directive: any, content: any, level: any, options: any): any;
export declare function preserveDirectives(content: any): Promise<any>;
export declare function preserveDirectivesInTag(content: any): Promise<unknown>;
export declare function revertDirectives(content: any): Promise<any>;
export declare function revertDirectivesInTag(content: any): Promise<any>;
export declare function printDescription(): void;
export declare function checkResult(formatted: any): any;
export declare function escapeReplacementString(string: string): string;
export declare function debugLog(...content: any): any;
export declare function getEndOfLine(endOfLine?: EndOfLine): string;
export declare function isInline(content: any): boolean;
export declare function indentRawPhpBlock(indent: detectIndent.Indent, content: any, formatter: Formatter): any;
export declare function indentPhpComment(indent: detectIndent.Indent, content: string, formatter: Formatter): any;
export declare function formatExpressionInsideBladeDirective(matchedExpression: string, indent: detectIndent.Indent, formatter: Formatter, wrapLength?: number | undefined): Promise<any>;
export declare function indentBladeDirectiveBlock(indent: detectIndent.Indent, content: any, formatter: Formatter): any;
export declare function isMultilineStatement(rawBlock: any, formatter: Formatter): Promise<boolean>;
export declare function indentRawBlock(indent: detectIndent.Indent, content: any, formatter: Formatter): any;
export declare function indentComponentAttribute(prefix: string, content: string, formatter: Formatter): any;
export declare function formatAsHtml(data: any, formatter: Formatter): Promise<any>;
export declare function formatAsBlade(content: any, formatter: Formatter): Promise<any>;
export declare function formatJS(jsCode: string): string;
export declare function getPlaceholder(attribute: string, replace: any, length?: any): any;
