<x-layouts.app>

    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-gray-100">{{ __('Dashboard')}}</h1>
        <p class="text-gray-600 dark:text-gray-400 mt-1">{{ __('Welcome to the dashboard') }}</p>

        @if($settings)
            <div class="mt-4 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg">
                <h3 class="text-lg font-semibold text-blue-800 dark:text-blue-200 mb-2">Current Settings</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                    @if($settings->website_name)
                        <div><span class="font-medium">Website:</span> {{ $settings->website_name }}</div>
                    @endif
                    @if($settings->theme)
                        <div><span class="font-medium">Theme:</span> {{ $settings->theme }}</div>
                    @endif
                    @if($settings->email)
                        <div><span class="font-medium">Email:</span> {{ $settings->email }}</div>
                    @endif
                    @if($settings->number)
                        <div><span class="font-medium">Phone:</span> {{ $settings->number }}</div>
                    @endif
                </div>
                <div class="mt-3">
                    <a href="{{ route('settings.index') }}" class="text-blue-600 dark:text-blue-400 hover:underline text-sm">
                        Manage Settings →
                    </a>
                </div>
            </div>
        @endif
    </div>

    <!-- Services Management Section -->
    <div class="mb-6">
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm p-6 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-200">Services Management</h3>
                <a href="{{ route('services.index') }}" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded text-sm">
                    Manage Services
                </a>
            </div>
            <p class="text-gray-600 dark:text-gray-400 text-sm mb-4">
                Manage your business services, pricing, and descriptions. Add, edit, or remove services as needed.
            </p>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-700 dark:text-gray-300">Total Services</p>
                            <p class="text-2xl font-bold text-gray-800 dark:text-gray-100">{{ \App\Models\Service::count() }}</p>
                        </div>
                        <div class="bg-blue-100 dark:bg-blue-900 p-2 rounded-full">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-500 dark:text-blue-300" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z" />
                            </svg>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-700 dark:text-gray-300">Active Services</p>
                            <p class="text-2xl font-bold text-gray-800 dark:text-gray-100">{{ \App\Models\Service::where('is_active', true)->count() }}</p>
                        </div>
                        <div class="bg-green-100 dark:bg-green-900 p-2 rounded-full">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-green-500 dark:text-green-300" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-700 dark:text-gray-300">Average Price</p>
                            <p class="text-2xl font-bold text-gray-800 dark:text-gray-100">${{ number_format(\App\Models\Service::where('is_active', true)->avg('price') ?? 0, 0) }}</p>
                        </div>
                        <div class="bg-purple-100 dark:bg-purple-900 p-2 rounded-full">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-purple-500 dark:text-purple-300" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>
