@extends('themes.coursesell.layout')

@section('content')
<div class="bg-gradient-to-br from-green-50 to-teal-50 py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Hero Section -->
        <div class="text-center mb-16">
            <h1 class="text-5xl font-bold text-gray-900 mb-6">
                About {{ $settings->website_name ?? 'CourseSell' }}
            </h1>
            <p class="text-xl text-gray-600 mb-8 max-w-3xl mx-auto">
                We are the leading platform for {{ $settings->website_content_name ?? 'online education' }}.
                Our mission is to connect learners with expert instructors worldwide.
            </p>
        </div>

        <!-- Company Info -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 mb-16">
            <div>
                <h2 class="text-3xl font-bold text-gray-900 mb-6">Our Story</h2>
                <p class="text-lg text-gray-600 mb-6">
                    {{ $settings->website_name ?? 'CourseSell' }} was founded with a simple vision: to democratize education
                    and make quality learning accessible to everyone. We believe that knowledge should be available
                    to anyone, anywhere, at any time.
                </p>
                <p class="text-lg text-gray-600">
                    Today, we serve thousands of students and instructors worldwide, offering a comprehensive
                    platform for creating, sharing, and consuming educational content.
                </p>
            </div>
            <div class="bg-white rounded-xl shadow-lg p-8">
                <h3 class="text-2xl font-bold text-gray-900 mb-6">Quick Facts</h3>
                <div class="space-y-4">
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Platform:</span>
                        <span class="font-semibold text-green-600">{{ $settings->website_name ?? 'CourseSell' }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Theme:</span>
                        <span class="font-semibold text-teal-600">{{ $theme->label() }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Focus:</span>
                        <span class="font-semibold text-emerald-600">{{ $settings->website_content_name ?? 'Online Education' }}</span>
                    </div>
                    @if($settings->email)
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Contact:</span>
                        <span class="font-semibold text-cyan-600">{{ $settings->email }}</span>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Team Section -->
        <div class="bg-white rounded-xl shadow-lg p-8 mb-16">
            <h2 class="text-3xl font-bold text-gray-900 mb-8 text-center">Our Team</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="text-center">
                    <div class="bg-green-100 w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-12 h-12 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-2">Sarah Johnson</h3>
                    <p class="text-gray-600">CEO & Founder</p>
                </div>
                <div class="text-center">
                    <div class="bg-teal-100 w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-12 h-12 text-teal-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-2">David Chen</h3>
                    <p class="text-gray-600">Head of Education</p>
                </div>
                <div class="text-center">
                    <div class="bg-emerald-100 w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-12 h-12 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-2">Maria Garcia</h3>
                    <p class="text-gray-600">Lead Instructor</p>
                </div>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="text-center bg-gradient-to-r from-green-600 to-teal-600 rounded-xl p-8 text-white">
            <h2 class="text-3xl font-bold mb-4">Join Our Learning Community</h2>
            <p class="text-xl mb-6 opacity-90">Start teaching or learning today.</p>
            <a href="{{ route('pricing') }}" class="bg-white text-green-600 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition">
                View Pricing
            </a>
        </div>
    </div>
</div>
@endsection
