<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }} - CourseSell</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="font-sans antialiased">
    <div class="min-h-screen bg-gray-50">
        <!-- CourseSell Theme Header -->
        <header class="bg-gradient-to-r from-green-600 to-teal-600 text-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center py-6">
                    <div class="flex items-center">
                        <h1 class="text-2xl font-bold">CourseSell</h1>
                    </div>
                    <nav class="hidden md:flex space-x-8">
                        <a href="#" class="hover:text-green-200 transition">Courses</a>
                        <a href="#" class="hover:text-green-200 transition">Instructors</a>
                        <a href="#" class="hover:text-green-200 transition">About</a>
                        <a href="#" class="hover:text-green-200 transition">Contact</a>
                        <a href="{{ route('dashboard') }}" class="bg-white/20 hover:bg-white/30 px-3 py-1 rounded transition">Admin</a>
                    </nav>
                </div>
            </div>
        </header>

        <!-- Main Content -->
        <main>
            @yield('content')
        </main>

        <!-- CourseSell Theme Footer -->
        <footer class="bg-gray-800 text-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
                <div class="text-center">
                    <p>&copy; {{ date('Y') }} CourseSell. All rights reserved.</p>
                </div>
            </div>
        </footer>
    </div>
</body>
</html>
