@extends('themes.digimarket.layout')

@section('content')
    	<!-- Banner  -->
        <div class="dlab-bnr-inr overlay-gradient-dark before:opacity-80 before:bg-primary w-full h-[400px] max-lg:h-[250px] max-sm:!h-[320px] bg-cover bg-center relative overflow-hidden bg-[url('../../assets/images/banner/bnr1.jpg')]" style="padding-top: 100px; padding-bottom: 100px;">
            <div class="container table h-full relative z-1">
                <div class="h-[300px] max-lg:h-[250px] max-md:!h-[220px] table-cell align-middle text-white max-md:!text-center">
                    <h1 class="!text-white mb-[15px] max-sm:mb-[5px] max-sm:text-[30px] uppercase">Pricing</h1>
                    <!-- Breadcrumb Row -->
                    <nav class="breadcrumb-row max-md:inline-block">
                        <ul class="flex flex-wrap">
                            <li class="ltr:mr-[3px] rtl:ml-[3px] flex items-center text-lg max-lg:text-[15px] font-poppins"><a href="{{ route('home') }}">Home</a></li>
                            <li class="ltr:mr-[3px] rtl:ml-[3px] flex items-center text-lg max-lg:text-[15px] font-poppins ltr:pl-2 rtl:pr-2 before:content-['\f105'] before:font-['Line_Awesome_Free'] before:font-bold ltr:before:pr-2 rtl:before:pl-2 active">Pricing</li>
                        </ul>
                    </nav>
                    <!-- Breadcrumb Row End -->
                </div>
            </div>
        </div>
    <!-- Banner End -->
		<!-- Services Section -->
		<section class="lg:pt-[115px] sm:pt-[70px] pt-[50px] bg-no-repeat bg-center bg-[length:100%] bg-[url('../images/background/bg19.png')]">
			<div class="container">
				<div class="mb-10 max-xl:mb-7.5 text-center">
					<h6 class="!text-[#777777] text-[22px] inline-block mb-0 max-xl:text-lg font-semibold">SERVICES</h6>
					<h2 class="title">OUR DIGITAL MARKETING SERVICES</h2>
					<p class="text-lg text-gray-600 mt-4">Comprehensive digital marketing solutions tailored to grow your business</p>
				</div>
				<div class="row">
					@foreach($services as $service)
					<div class="lg:w-1/3 md:w-1/2 w-full wow fadeInUp" data-wow-duration="2s" data-wow-delay="{{ $loop->index * 0.2 }}s">
						<div class="service-card relative bg-white shadow-wrapper p-7.5 duration-1000 rounded hover:translate-y-[-15px] text-center mb-7.5">

							@php
								$colors = ['bg-primary', 'bg-green', 'bg-yellow', 'bg-blue', 'bg-red', 'bg-purple', 'bg-orange', 'bg-teal', 'bg-indigo'];
								$color = $colors[$loop->index % count($colors)];
							@endphp
							<div class="icon-bx-sm {{ $color }} text-white inline-block text-center rounded-full size-[70px] leading-[70px] mb-5">
								<a href="javascript:void(0);" class="icon-cell">
																											@php
										$icons = [
											'flaticon-line-graph',
											'flaticon-idea',
											'flaticon-rocket',
											'flaticon-smile',
											'flaticon-startup',
											'flaticon-confetti',
											'flaticon-chart',
											'fa fa-cog',
											'fa fa-headset'
										];
										$icon = $icons[$loop->index % count($icons)];
									@endphp
									<i class="{{ $icon }} text-[35px]"></i>
								</a>
							</div>
							<div class="icon-content">
								<h4 class="dlab-title mb-3">{{ $service->name }}</h4>
								@if($service->price)
								<div class="service-price mb-4">
									<span class="price-amount">${{ number_format($service->price, 2) }}</span>
									<span class="price-label">Starting Price</span>
								</div>
								@endif
								<p class="mb-5 text-gray-600">{{ Str::limit($service->description, 120) }}</p>
								<a href="{{ route('contact') }}" class="btn py-4 px-8 text-sm inline-block font-medium leading-[1.2] uppercase bg-primary hover:bg-primaryhover text-white rounded duration-700 group">
									Get Quote
									<i class="fa fa-angle-right ltr:ml-2.5 rtl:mr-2.5 duration-1000 group-hover:animate-toLeftFromRight"></i>
								</a>
							</div>
						</div>
					</div>
					@endforeach
				</div>
			</div>
		</section>
@endsection
