@extends('themes.digimarket.layout')

@section('content')
    	<!-- Banner  -->
        <div class="dlab-bnr-inr overlay-gradient-dark before:opacity-80 before:bg-primary w-full h-[400px] max-lg:h-[250px] max-sm:!h-[320px] bg-cover bg-center relative overflow-hidden bg-[url('../../assets/images/banner/bnr1.jpg')]" style="padding-top: 100px; padding-bottom: 100px;">
            <div class="container table h-full relative z-1">
                <div class="h-[300px] max-lg:h-[250px] max-md:!h-[220px] table-cell align-middle text-white max-md:!text-center">
                    <h1 class="!text-white mb-[15px] max-sm:mb-[5px] max-sm:text-[30px] uppercase">Privacy Policy</h1>
                    <!-- Breadcrumb Row -->
                    <nav class="breadcrumb-row max-md:inline-block">
                        <ul class="flex flex-wrap">
                            <li class="ltr:mr-[3px] rtl:ml-[3px] flex items-center text-lg max-lg:text-[15px] font-poppins"><a href="{{ route('home') }}">Home</a></li>
                            <li class="ltr:mr-[3px] rtl:ml-[3px] flex items-center text-lg max-lg:text-[15px] font-poppins ltr:pl-2 rtl:pr-2 before:content-['\f105'] before:font-['Line_Awesome_Free'] before:font-bold ltr:before:pr-2 rtl:before:pl-2 active">Privacy Policy</li>
                        </ul>
                    </nav>
                    <!-- Breadcrumb Row End -->
                </div>
            </div>
        </div>
    <!-- Banner End -->

    <section class="lg:pt-[15px] lg:pb-[85px] sm:pt-[10px] sm:pb-10 pt-[10px] pb-5 bg-img-fix">
        <div class="container">
            <div class="row">
                <div class=" mb-[50px]">
                    <!-- blog start -->
                    <div class="dlab-blog blog-single style-1 sidebar">

                        <div class="pt-7.5 mb-[50px]">
                            <h1 class="text-[50px] font-bold text-primary mb-6">Privacy Policy</h1>
                            <div class="mt-5 leading-[1.7] text-lg dlab-post-text">
                                <h2 class="text-2xl font-bold mb-6 text-gray-800">1. Our Data Collection Practices</h2>
                                <p class="mb-[1.65em]">{{ $settings->website_content_name ?? 'DigiMarket' }} ("we", "our", or "us") is an international software development company. This Privacy Policy ("Policy") outlines our online data protection practices. It explains what information we collect about you when you visit our website ({{ $settings->website_url ?? 'www.digimarket.com' }}) and how we use, share, and protect that information. This Policy also explains your rights regarding your data and how you can exercise them.</p>

                                <p class="mb-[1.65em]">By using our website, you agree to this Policy. Please review it regularly for updates. If you have questions, contact us at {{ $settings->email ?? 'info@digimarket.com' }}.</p>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">2. How We Use Your Data</h2>
                                <p class="mb-[1.65em]">We follow the EU General Data Protection Regulation (GDPR) and local laws to ensure your personal data is handled securely. We collect and process personal data to improve our services, communicate with you, and comply with legal obligations.</p>

                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li>To respond to inquiries submitted via our contact form or email.</li>
                                    <li>To provide and manage our services effectively.</li>
                                    <li>For recruitment purposes, including reviewing job applications and conducting interviews.</li>
                                    <li>To enhance user experience through analytics and cookies.</li>
                                </ul>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">3. Types of Information We Collect</h2>
                                <p class="mb-[1.65em]">We collect only the information necessary for providing our services. This includes:</p>

                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li>Contact details (name, email address, phone number).</li>
                                    <li>Device and browsing data (IP address, browser type, geographic location).</li>
                                    <li>Application data (resumes, portfolios, and job history).</li>
                                </ul>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">4. Your Rights Under GDPR</h2>
                                <p class="mb-[1.65em]">Under the GDPR, you have the following rights:</p>

                                <ol class="list-decimal pl-6 mb-6 space-y-2">
                                    <li><strong>Access:</strong> Request details about the personal data we store.</li>
                                    <li><strong>Correction:</strong> Update or correct your data if it's inaccurate.</li>
                                    <li><strong>Deletion:</strong> Request the deletion of your personal data.</li>
                                    <li><strong>Restriction:</strong> Limit the processing of your data under certain circumstances.</li>
                                    <li><strong>Objection:</strong> Object to how we process your data.</li>
                                    <li><strong>Portability:</strong> Request your data in a structured, electronic format.</li>
                                    <li><strong>Withdraw Consent:</strong> Withdraw your consent for specific data uses.</li>
                                </ol>

                                <p class="mb-[1.65em]">To exercise these rights, email us at {{ $settings->email ?? 'info@digimarket.com' }}. We will respond within one month.</p>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">5. Data Security</h2>
                                <p class="mb-[1.65em]">We implement robust security measures to protect your data against unauthorized access, alteration, or deletion. Your data may be stored on secure servers or cloud storage solutions provided by trusted third-party vendors.</p>

                                <p class="mb-[1.65em]">We retain personal data only as long as necessary to fulfill the purposes outlined in this Policy or comply with legal obligations. When no longer needed, your data will be securely deleted.</p>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">6. Cookies</h2>
                                <p class="mb-[1.65em]">Our website uses cookies to improve your browsing experience. Cookies are small text files that store information about your preferences and activity on our website. We use:</p>

                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li><strong>Functional Cookies:</strong> Ensure the website operates smoothly.</li>
                                    <li><strong>Analytical Cookies:</strong> Help us analyze traffic and user behavior.</li>
                                    <li><strong>Third-Party Cookies:</strong> Used by partners for marketing and analytics.</li>
                                </ul>

                                <p class="mb-[1.65em]">You can manage cookie settings through your browser. Note that disabling cookies may limit some features on our website.</p>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">7. Contact Us</h2>
                                <p class="mb-[1.65em]">If you have any questions about this Policy or our data practices, please contact us at:</p>

                                <div class="bg-gray-50 p-6 rounded-lg mb-6">
                                    <p class="font-semibold text-lg mb-2">{{ $settings->website_content_name ?? 'DigiMarket' }}</p>
                                    <p class="mb-1"><strong>Email:</strong> {{ $settings->email ?? 'info@digimarket.com' }}</p>
                                    <p class="mb-1"><strong>Website:</strong> {{url('/')}}</p>
                                    @if($settings->address)
                                        <p class="mb-1"><strong>Address:</strong> {{ $settings->address }}</p>
                                    @endif
                                    @if($settings->number)
                                        <p class="mb-1"><strong>Phone:</strong> {{ $settings->number }}</p>
                                    @endif
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- blog END -->
                </div>
            </div>
        </div>
    </section>

@endsection
