@extends('themes.digimarket2.layout')

@section('content')
    	    	<!-- Banner  -->
		
		<div class="dlab-bnr-inr style-1 bg-primary w-full h-[480px] max-sm:h-[300px] bg-center bg-[length:cover,_200%] relative overflow-hidden" style="background-image: url(assets/images/banner/bnr2.png), var(--gradient-sec);">
			<div class="container table h-full relative z-1">
				<div class="h-full table-cell align-middle text-white relative text-center dlab-bnr-inr-entry">
					<h1 class="!text-white mb-5 max-sm:mb-[5px] text-[60px] max-lg:text-[40px] max-sm:!text-[32px] leading-[75px] max-lg:leading-[1.2]">Terms And Conditions</h1>
					<!-- Breadcrumb Row -->
					<nav class="breadcrumb-row max-md:inline-block">
						<ul class="inline-flex flex-wrap gradient bg-[length:200%] duration-1000 py-[5px] px-5 rounded-[30px]">
							<li class="ltr:mr-[3px] rtl:ml-[3px] flex items-center text-lg max-lg:text-[15px] font-poppins"><a href="index.html">Home</a></li>
							<li class="ltr:mr-[3px] rtl:ml-[3px] flex items-center text-lg max-lg:text-[15px] font-poppins ltr:pl-2 rtl:pr-2 before:content-['\f105'] before:font-['Line_Awesome_Free'] before:font-bold ltr:before:pr-2 rtl:before:pl-2 active">Terms And Conditions</li>
						</ul>
					</nav>
					<!-- Breadcrumb Row End -->
				</div>
			</div>
		</div>
		<!-- Banner End -->

    <section class="lg:pt-[15px] lg:pb-[85px] sm:pt-[10px] sm:pb-10 pt-[10px] pb-5 bg-img-fix">
        <div class="container">
            <div class="row">
                <div class=" mb-[50px]">
                    <!-- blog start -->
                    <div class="dlab-blog blog-single style-1 sidebar">

                        <div class="pt-7.5 mb-[50px]">
                            <h1 class="text-[50px] font-bold text-primary mb-6">Terms & Conditions</h1>
                            <div class="mt-5 leading-[1.7] text-lg dlab-post-text">
                                <div class="bg-blue-50 border-l-4 border-blue-400 p-4 mb-6">
                                    <p class="mb-[1.65em]"><strong>Please note:</strong> The transaction description on your card will be <strong>{{ $settings->website_content_name ?? 'ARHAM BAREE LLC' }}</strong> (One-Time Charge)</p>
                                </div>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800">1. Service Delivery & Timeline</h2>
                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li>All plan services will be provided to the customer digitally via the Internet.</li>
                                    <li>All services are completed within 1 to 7 days from the order placing date.</li>
                                </ul>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">2. Estimates & Quotes</h2>
                                <p class="mb-[1.65em]">Our estimates/quotes are based on your provided requirements and stipulated timeframes. Any alterations to functionality, including micro-improvements, may result in additional costs. Please ensure a comprehensive discussion in a face-to-face meeting to clarify our understanding.</p>

                                <p class="mb-[1.65em]">Acceptance of a quote implies agreement to {{ $settings->website_content_name ?? 'DigiMarket' }} terms and conditions. Acceptance can be verbal, via email, payment of initiation, or signing a quote.</p>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">3. Project Requirements & Communication</h2>
                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li>Clients must ensure all requirements are included in quotes/proposals/estimates and that we fully comprehend their needs.</li>
                                    <li>Clear guidelines and details provided by clients assist in accurate quoting. Any discrepancies arising from unclear requirements may incur additional costs.</li>
                                    <li>Clients are urged to disclose any complexity related to specific tasks in advance for cost estimation.</li>
                                    <li>We rely on clients to provide a complete project brief at the quoting stage. Discrepancies due to unclear requirements will not be the responsibility of {{ $settings->website_content_name ?? 'DigiMarket' }}.</li>
                                </ul>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">4. Work Hours & Modifications</h2>
                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li>Limited man-hours are allocated to each task, including Project Management and Digital Strategist/Business Analyst time.</li>
                                    <li>Minor changes within allocated hours are considered on a case-by-case basis.</li>
                                    <li>Re-work on completed tasks or design changes post-approval may incur additional charges.</li>
                                    <li>Modifications during or after Go-Live approval will result in additional charges.</li>
                                    <li>Any additional work beyond estimates is charged separately.</li>
                                </ul>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">5. Deadlines & Delays</h2>
                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li>We endeavor to complete projects/changes within given timeframes. Reasonable delays are accepted if functionalities are redefined or modified.</li>
                                    <li>Client-induced delays may affect project timeframes and could result in additional costs.</li>
                                    <li>Halting the project for over two months incurs administration costs. Continued halting may affect previously approved estimates.</li>
                                </ul>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">6. Testing & Deployment</h2>
                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li>Our websites/applications are primarily tested on PCs using recent versions of browsers like IE, Firefox, Chrome, and Safari. Other browser testing must be requested in advance.</li>
                                    <li>Responsive/multi-device pages are tested on iPhones and iPads. Testing on other devices requires prior discussion.</li>
                                    <li>If your website/application is not hosted on a {{ $settings->website_content_name ?? 'DigiMarket' }} server, additional man-hours for server/network-related issues are not included and may be charged separately.</li>
                                </ul>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">7. Ownership & Intellectual Property</h2>
                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li>{{ $settings->website_content_name ?? 'DigiMarket' }} software codes are copyrights of {{ $settings->website_content_name ?? 'DigiMarket' }}. Codes can be handed over at an additional cost post-settlement of invoices. Usage is limited to the specified client or subsequent owners, not for resale or duplication.</li>
                                    <li>{{ $settings->website_content_name ?? 'DigiMarket' }} CMS ownership remains with {{ $settings->website_content_name ?? 'DigiMarket' }}. A license is granted to the client while paying for hosting. Transfer to an external host is not permitted.</li>
                                    <li>Upon payment, unconditional licenses for certain aspects of the website are granted to clients. However, intellectual property related to website production remains with {{ $settings->website_content_name ?? 'DigiMarket' }}.</li>
                                </ul>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">8. Third-Party Components</h2>
                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li>Third-party components such as Payment Gateways or SSL certificates may be involved. Any unforeseen limitations are beyond our control and may incur additional costs.</li>
                                    <li>We're not responsible for open-source products' upkeep. Clients must update all components regularly and maintain backups.</li>
                                    <li>Changes in third-party provider rules may affect our services or terms.</li>
                                    <li>Unforeseen circumstances may delay development, especially with third-party software integration.</li>
                                </ul>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">9. Additional Terms</h2>
                                <ul class="list-disc pl-6 mb-6 space-y-2">
                                    <li>Domain registration/renewal charges are separate unless otherwise mentioned.</li>
                                    <li>Hosting charges are separate unless otherwise stated. If we organize hosting, it must meet project technology requirements.</li>
                                    <li>We build/test on our servers or domains. Test server access isn't provided. Transfer to a nominated server occurs post full payment.</li>
                                    <li>Content and related materials must be provided within the first two weeks of project commencement. Delays beyond this period may incur additional charges if deemed unreasonable.</li>
                                    <li>Communications are primarily conducted via email. Clients must update relevant email addresses.</li>
                                </ul>

                                <h2 class="text-2xl font-bold mb-6 text-gray-800 mt-8">10. Contact Information</h2>
                                <p class="mb-[1.65em]">For any questions regarding these terms and conditions, please contact us:</p>

                                <div class="bg-gray-50 p-6 rounded-lg mb-6">
                                    <p class="font-semibold text-lg mb-2">{{ $settings->website_content_name ?? 'DigiMarket' }}</p>
                                    <p class="mb-1"><strong>Email:</strong> {{ $settings->email ?? 'info@digimarket.com' }}</p>
                                    <p class="mb-1"><strong>Website:</strong> {{url('/')}}</p>
                                    @if($settings->address)
                                        <p class="mb-1"><strong>Address:</strong> {{ $settings->address }}</p>
                                    @endif
                                    @if($settings->number)
                                        <p class="mb-1"><strong>Phone:</strong> {{ $settings->number }}</p>
                                    @endif
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- blog END -->
                </div>
            </div>
        </div>
    </section>

@endsection
