<?php

use App\Http\Controllers\Settings;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ThemeController;
use App\Http\Controllers\Admin\ServiceController;
use Illuminate\Support\Facades\Route;

Route::get('/', [ThemeController::class, 'index'])->name('home');

// Theme pages - these will automatically use the current theme
Route::get('/about', [ThemeController::class, 'about'])->name('about');
Route::get('/contact', [ThemeController::class, 'contact'])->name('contact');
Route::get('/pricing', [ThemeController::class, 'pricing'])->name('pricing');
Route::get('/privacy-policy', [ThemeController::class, 'privacyPolicy'])->name('privacy-policy');
Route::get('/terms-conditions', [ThemeController::class, 'termsConditions'])->name('terms-conditions');
Route::get('/refund-policy', [ThemeController::class, 'refundPolicy'])->name('refund-policy');


Route::get('dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::middleware(['auth'])->group(function () {
    Route::get('settings/profile', [Settings\ProfileController::class, 'edit'])->name('settings.profile.edit');
    Route::put('settings/profile', [Settings\ProfileController::class, 'update'])->name('settings.profile.update');
    Route::delete('settings/profile', [Settings\ProfileController::class, 'destroy'])->name('settings.profile.destroy');
    Route::get('settings/password', [Settings\PasswordController::class, 'edit'])->name('settings.password.edit');
    Route::put('settings/password', [Settings\PasswordController::class, 'update'])->name('settings.password.update');
    Route::get('settings/appearance', [Settings\AppearanceController::class, 'edit'])->name('settings.appearance.edit');

    // Settings routes
    Route::get('settings', [SettingsController::class, 'index'])->name('settings.index');
    Route::put('settings', [SettingsController::class, 'update'])->name('settings.update');

    // Services management
    Route::resource('services', ServiceController::class);
});

require __DIR__.'/auth.php';
