<?php $__env->startSection('content'); ?>
<div class="bg-gradient-to-br from-green-50 to-teal-50 py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Hero Section -->
        <div class="text-center mb-16">
            <h1 class="text-5xl font-bold text-gray-900 mb-6">
                Welcome to <?php echo e($settings->website_name ?? 'CourseSell'); ?>

            </h1>
            <p class="text-xl text-gray-600 mb-8 max-w-3xl mx-auto">
                Your premier platform for <?php echo e($settings->website_content_name ?? 'online courses'); ?>.
                Learn from expert instructors and advance your skills.
            </p>
            <div class="flex justify-center space-x-4">
                <a href="#" class="bg-green-600 hover:bg-green-700 text-white px-8 py-3 rounded-lg font-semibold transition">
                    Browse Courses
                </a>
                <a href="#" class="bg-teal-600 hover:bg-teal-700 text-white px-8 py-3 rounded-lg font-semibold transition">
                    Become Instructor
                </a>
            </div>
        </div>

        <!-- Settings Display -->
        <div class="bg-white rounded-xl shadow-lg p-8 mb-16">
            <h2 class="text-3xl font-bold text-gray-900 mb-6 text-center">Current Settings</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <div class="bg-green-50 p-6 rounded-lg">
                    <h3 class="text-lg font-semibold text-green-900 mb-2">Theme</h3>
                    <p class="text-green-700"><?php echo e($theme->label()); ?></p>
                    <p class="text-sm text-green-600 mt-1"><?php echo e($theme->description()); ?></p>
                </div>

                <?php if($settings->website_name): ?>
                <div class="bg-teal-50 p-6 rounded-lg">
                    <h3 class="text-lg font-semibold text-teal-900 mb-2">Website Name</h3>
                    <p class="text-teal-700"><?php echo e($settings->website_name); ?></p>
                </div>
                <?php endif; ?>

                <?php if($settings->website_content_name): ?>
                <div class="bg-emerald-50 p-6 rounded-lg">
                    <h3 class="text-lg font-semibold text-emerald-900 mb-2">Content Type</h3>
                    <p class="text-emerald-700"><?php echo e($settings->website_content_name); ?></p>
                </div>
                <?php endif; ?>

                <?php if($settings->email): ?>
                <div class="bg-cyan-50 p-6 rounded-lg">
                    <h3 class="text-lg font-semibold text-cyan-900 mb-2">Contact Email</h3>
                    <p class="text-cyan-700"><?php echo e($settings->email); ?></p>
                </div>
                <?php endif; ?>

                <?php if($settings->number): ?>
                <div class="bg-blue-50 p-6 rounded-lg">
                    <h3 class="text-lg font-semibold text-blue-900 mb-2">Phone Number</h3>
                    <p class="text-blue-700"><?php echo e($settings->number); ?></p>
                </div>
                <?php endif; ?>

                <?php if($settings->address): ?>
                <div class="bg-indigo-50 p-6 rounded-lg">
                    <h3 class="text-lg font-semibold text-indigo-900 mb-2">Address</h3>
                    <p class="text-indigo-700"><?php echo e($settings->address); ?></p>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Features Section -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-16">
            <div class="text-center">
                <div class="bg-green-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Expert Instructors</h3>
                <p class="text-gray-600">Learn from industry professionals and certified experts.</p>
            </div>

            <div class="text-center">
                <div class="bg-teal-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-teal-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Certified Courses</h3>
                <p class="text-gray-600">Get certificates upon completion of your courses.</p>
            </div>

            <div class="text-center">
                <div class="bg-emerald-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Lifetime Access</h3>
                <p class="text-gray-600">Access your courses anytime, anywhere, forever.</p>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="text-center bg-gradient-to-r from-green-600 to-teal-600 rounded-xl p-8 text-white">
            <h2 class="text-3xl font-bold mb-4">Start Learning Today?</h2>
            <p class="text-xl mb-6 opacity-90">Join thousands of students advancing their careers.</p>
            <a href="#" class="bg-white text-green-600 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition">
                Explore Courses
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('themes.coursesell.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/iqurdffe/wavedigi.net/resources/views/themes/coursesell/home.blade.php ENDPATH**/ ?>